<?php

include "../config/database.php";
include "cek_login.php";

$limit = 50; // jumlah data per halaman
$page  = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page  = ($page < 1) ? 1 : $page;
$start = ($page - 1) * $limit;

$total = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT COUNT(*) as total FROM siswa")
)['total'];

$total_page = ceil($total / $limit);


// Rekap verifikasi
$kelas = mysqli_query($conn, "
SELECT DISTINCT kelas
FROM siswa
ORDER BY
    CASE 
        WHEN kelas LIKE 'X.%' THEN 1
        WHEN kelas LIKE 'XI.%' THEN 2
        WHEN kelas LIKE 'XII.%' THEN 3
        ELSE 99
    END,
    CAST(SUBSTRING_INDEX(kelas, '.', -1) AS UNSIGNED)
");


$data = mysqli_query($conn, "
    SELECT 
        s.id, s.nisn, s.nama, s.kelas,
        IFNULL(v.status,'BELUM') AS status,
        v.waktu_verifikasi
    FROM siswa s
    LEFT JOIN verifikasi_nilai v ON s.id = v.siswa_id
    ORDER BY s.kelas ASC, s.nama ASC
    LIMIT $start, $limit
");

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<!-- NAVBAR -->
<nav class="navbar navbar-dark bg-dark shadow">
  <div class="container-fluid">
    <span class="navbar-brand mb-0 h1">
        <i class="fas fa-user-shield me-2"></i> Admin Panel
    </span>
    <div>
        <span class="text-white me-3">
            <?= $_SESSION['admin_nama'] ?>
        </span>
        <a href="logout.php" class="btn btn-danger btn-sm">
            <i class="fas fa-sign-out-alt"></i> Logout
        </a>
    </div>
  </div>
</nav>

<div class="container mt-4">

<!-- ACTION BUTTON -->
<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-chart-bar me-2"></i> Rekap Verifikasi Nilai</h4>
    <div>
        <a href="nilai_upload.php" class="btn btn-primary btn-sm">
            <i class="fas fa-upload"></i> Upload Nilai
        </a>
        <a href="siswa_tambah.php" class="btn btn-success btn-sm">
            <i class="fas fa-user-plus"></i> Tambah Siswa
        </a>
          <a href="upload_siswa.php" class="btn btn-success btn-sm">
            <i class="fas fa-user-plus"></i> Upload Siswa (Excel)
        </a>
        <a href="siswa_export.php" class="btn btn-warning btn-sm">
    <i class="fas fa-file-export"></i> Export Excel
</a>

    </div>
</div>

<div class="row mb-3 g-2">
  <div class="col-md-4">
    <input type="text" id="search" class="form-control"
           placeholder="Cari NISN / Nama / Kelas...">
  </div>

  <div class="col-md-3">
    <select id="filter_kelas" class="form-select">
        <option value="">Semua Kelas</option>
        <?php
        $kelas = mysqli_query($conn,"SELECT DISTINCT kelas FROM siswa ORDER BY kelas ASC");
        while($k=mysqli_fetch_assoc($kelas)):
        ?>
            <option value="<?= $k['kelas'] ?>">
                <?= $k['kelas'] ?>
            </option>
        <?php endwhile ?>
    </select>
</div>

</div>



<div class="mb-2 text-muted small">
    Menampilkan <?= $start+1 ?> –
    <?= min($start+$limit, $total) ?>
    dari <?= $total ?> siswa
</div>


<!-- TABLE -->
<div class="card shadow-sm">
<div class="card-body">

<table class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
    <th width="5%">No</th>
    <th>NISN</th>
    <th>Nama</th>
    <th>Kelas</th>
    <th>Status</th>
    <th>Waktu</th>
    <th width="10%">Aksi</th>
</tr>
</thead>

<tbody id="tbody">
<?php $no=1; while($d=mysqli_fetch_assoc($data)): ?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= $d['nisn'] ?></td>
    <td><?= $d['nama'] ?></td>
    <td><?= $d['kelas'] ?></td>
    <td>
        <?= $d['status']=='SUDAH'
            ? '<span class="badge bg-success">SUDAH</span>'
            : '<span class="badge bg-danger">BELUM</span>' ?>
    </td>
    <td><?= $d['waktu_verifikasi'] ?? '-' ?></td>
        <td class="text-center">
    <a href="siswa_nilai.php?id=<?= $d['id'] ?>"
       class="btn btn-info btn-sm mb-1">
       <i class="fas fa-eye"></i>
    </a>

    <a href="siswa_hapus.php?id=<?= $d['id'] ?>"
       onclick="return confirm('Hapus siswa ini?')"
       class="btn btn-danger btn-sm">
       <i class="fas fa-trash"></i>
    </a>
</td>

</tr>
<?php endwhile ?>
</tbody>

</table>

<nav>
<ul class="pagination justify-content-center mt-3">

<?php if($page > 1): ?>
<li class="page-item">
    <a class="page-link" href="?page=<?= $page-1 ?>">«</a>
</li>
<?php endif ?>

<?php for($i=1; $i<=$total_page; $i++): ?>
<li class="page-item <?= ($i==$page?'active':'') ?>">
    <a class="page-link" href="?page=<?= $i ?>">
        <?= $i ?>
    </a>
</li>
<?php endfor ?>

<?php if($page < $total_page): ?>
<li class="page-item">
    <a class="page-link" href="?page=<?= $page+1 ?>">»</a>
</li>
<?php endif ?>

</ul>
</nav>

</div>
</div>

</div>
<script>
const search = document.getElementById('search');

search.addEventListener('keyup', function () {
    const keyword = this.value;

    fetch('siswa_search.php?keyword=' + keyword)
        .then(res => res.text())
        .then(data => {
            document.getElementById('tbody').innerHTML = data;
        });
});
</script>
<script>
document.addEventListener('DOMContentLoaded', function () {

    const search = document.getElementById('search');
    const filterKelas = document.getElementById('filter_kelas');
    const tbody = document.getElementById('tbody');

    function loadData() {
        const keyword = encodeURIComponent(search.value);
        const kelas   = encodeURIComponent(filterKelas.value);

        const url = `siswa_search.php?keyword=${keyword}&kelas=${kelas}`;
        console.log('FETCH:', url); // DEBUG

        fetch(url)
            .then(res => res.text())
            .then(data => {
                tbody.innerHTML = data;
            });
    }

    search.addEventListener('keyup', loadData);
    filterKelas.addEventListener('change', loadData);

});
</script>

</body>
</html>
