<?php
include "../config/database.php";
include "cek_login.php";

require '../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\IOFactory;

if(isset($_POST['semester'])){

    $semester = (int)$_POST['semester'];
    $file = $_FILES['file']['tmp_name'];

    $spreadsheet = IOFactory::load($file);
    $sheet = $spreadsheet->getActiveSheet();
    $rows = $sheet->toArray();

    $header = $rows[0];

    mysqli_begin_transaction($conn);

    try {
        for($i=1; $i<count($rows); $i++){

            $row = $rows[$i];
            $nisn = trim($row[0]);
            if($nisn == '') continue;

            $siswa = mysqli_fetch_assoc(
                mysqli_query($conn,"SELECT id FROM siswa WHERE nisn='$nisn'")
            );
            if(!$siswa) continue;

            $siswa_id = $siswa['id'];

            mysqli_query($conn,"
                DELETE FROM nilai_raport
                WHERE siswa_id=$siswa_id AND semester=$semester
            ");

            for($c=2; $c<count($header); $c++){
                $mapel = trim($header[$c]);
                $nilai = $row[$c];

                if($mapel=='' || $nilai==='') continue;

                mysqli_query($conn,"
                    INSERT INTO nilai_raport
                    (siswa_id, semester, mapel, nilai)
                    VALUES
                    ($siswa_id, $semester, '$mapel', '$nilai')
                ");
            }
        }

        mysqli_commit($conn);
        $success = true;

    } catch(Exception $e){
        mysqli_rollback($conn);
        $error = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Upload Nilai</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-4">
<h4>Upload Nilai Rapor</h4>

<?php if(isset($success)): ?>
<div class="alert alert-success">Nilai berhasil diupload</div>
<?php endif ?>

<?php if(isset($error)): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif ?>

<form method="post" enctype="multipart/form-data">
    <div class="mb-3">
        <label>Semester</label>
        <select name="semester" class="form-select" required>
            <option value="">-- Pilih Semester --</option>
            <option value="1">Semester 1</option>
            <option value="2">Semester 2</option>
            <option value="3">Semester 3</option>
            <option value="4">Semester 4</option>
            <option value="5">Semester 5</option>
        </select>
    </div>

    <div class="mb-3">
        <label>File Excel</label>
        <input type="file" name="file" class="form-control" required>
    </div>

    <button class="btn btn-primary">
        <i class="fas fa-upload"></i> Upload
    </button>
    <a href="index.php" class="btn btn-secondary">Kembali</a>
</form>

</div>
</body>
</html>