<?php
include "../config/database.php";
include "cek_login.php";

$id = $_GET['id'] ?? null;
$semester = $_GET['semester'] ?? 1;

if(!$id){
    die("ID siswa tidak ditemukan");
}

// DATA SISWA
$siswa = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT * FROM siswa WHERE id='$id'")
);

if(!$siswa){
    die("Siswa tidak ditemukan");
}

// DATA NILAI
$nilai = mysqli_query($conn, "
    SELECT 
        m.nama AS nama_mapel,
        n.nilai
    FROM nilai_raport n
    JOIN mapel m ON n.mapel = m.kode
    WHERE n.siswa_id='$id'
    AND n.semester='$semester'
    ORDER BY m.id ASC
");
$rekap = mysqli_fetch_assoc(
    mysqli_query($conn,"
        SELECT 
            COUNT(*) AS jumlah_mapel,
            SUM(nilai) AS total_nilai,
            ROUND(AVG(nilai),2) AS rata_rata
        FROM nilai_raport
        WHERE siswa_id='$id'
        AND semester='$semester'
    ")
);


?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Nilai Siswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container mt-4">

<a href="index.php" class="btn btn-secondary btn-sm mb-3">
    <i class="fas fa-arrow-left"></i> Kembali
</a>

<div class="card shadow-sm mb-3">
<div class="card-body">
    <h5 class="mb-1"><?= $siswa['nama'] ?></h5>
    <div class="text-muted small">
        NISN: <?= $siswa['nisn'] ?> |
        Kelas: <?= $siswa['kelas'] ?>
    </div>
</div>
</div>

<!-- PILIH SEMESTER -->
<form method="get" class="mb-3">
<input type="hidden" name="id" value="<?= $id ?>">
<select name="semester" class="form-select w-auto d-inline" onchange="this.form.submit()">
    <?php for($i=1;$i<=5;$i++): ?>
        <option value="<?= $i ?>" <?= ($semester==$i?'selected':'') ?>>
            Semester <?= $i ?>
        </option>
    <?php endfor ?>
</select>
</form>

<!-- TABEL NILAI -->
<div class="card shadow-sm">
<div class="card-body">
<a href="nilai_cetak_pdf.php?id=<?= $id ?>&semester=<?= $semester ?>"
   target="_blank"
   class="btn btn-danger btn-sm mb-3">
   <i class="fas fa-file-pdf"></i> Cetak PDF
</a>

<table class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
    <th width="5%">No</th>
    <th>Mata Pelajaran</th>
    <th width="20%">Nilai</th>
</tr>
</thead>

<tbody>
<?php if(mysqli_num_rows($nilai)>0): ?>
    <?php $no=1; while($n=mysqli_fetch_assoc($nilai)): ?>
    <tr>
        <td><?= $no++ ?></td>
        <td><?= $n['nama_mapel'] ?></td>
        <td width="20%">
            <input type="number"
       class="form-control form-control-sm nilai-input"
       min="0"
       max="100"
       step="1"
       value="<?= $n['nilai'] ?>"
       data-id="<?= $id ?>"
       data-semester="<?= $semester ?>">
        </td>
    </tr>
    <?php endwhile ?>
<?php else: ?>
<tr>
    <td colspan="3" class="text-center text-muted">Nilai belum tersedia</td>
</tr>
<?php endif ?>
</tbody>

</table>

<div class="card shadow-sm mt-3">
<div class="card-body">
<div class="row text-center">

    <div class="col-md-4">
        <div class="fw-bold text-muted">Jumlah Mapel</div>
        <h4><?= $rekap['jumlah_mapel'] ?? 0 ?></h4>
    </div>

    <div class="col-md-4">
        <div class="fw-bold text-muted">Total Nilai</div>
        <h4><?= $rekap['total_nilai'] ?? 0 ?></h4>
    </div>

    <div class="col-md-4">
        <div class="fw-bold text-muted">Rata-rata</div>
        <h4 class="<?= ($rekap['rata_rata']>=75?'text-success':'text-danger') ?>">
            <?= $rekap['rata_rata'] ?? 0 ?>
        </h4>
    </div>

</div>
</div>
</div>


</div>
</div>

</div>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<script>
$('.nilai-input').on('change', function(){
    let input   = $(this);
    let nilai   = input.val();
    let siswa   = input.data('id');
    let semester= input.data('semester');
    let mapel   = input.closest('tr').find('td:eq(1)').text();

    // efek loading
    input.removeClass('is-valid is-invalid');
    input.css('background','#fff3cd');

    $.post(
        'nilai_update.php',
        {
            siswa_id: siswa,
            semester: semester,
            mapel: mapel,
            nilai: nilai
        },
        function(res){
            if(res.trim() === 'OK'){
                // sukses → hijau
                input.addClass('is-valid');
                input.css('background','#d1e7dd');

                setTimeout(()=>{
                    input.css('background','');
                    input.removeClass('is-valid');
                },1200);

            }else{
                // gagal → merah
                input.addClass('is-invalid');
                input.css('background','#f8d7da');
            }
        }
    )
    .fail(function(){
        input.addClass('is-invalid');
        input.css('background','#f8d7da');
    });
});
$('.nilai-input').on('input', function(){
    let v = parseInt(this.value);

    if(v < 0) this.value = 0;
    if(v > 100) this.value = 100;
});
if(res === 'OK'){
    location.reload(); // refresh agar total & rata-rata update
}

</script>


</body>
</html>
