<?php include "config/database.php"; ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">

<meta charset="UTF-8">
<title>Login | Verifikasi Nilai Rapor</title>

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Font Awesome -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<!-- Google Font -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<style>
* {
    font-family: 'Poppins', sans-serif;
}
body {
    min-height: 100vh;
    background:
        linear-gradient(120deg, rgba(13,110,253,0.9), rgba(102,16,242,0.9)),
        url('https://linggaupos.disway.id/upload/f7cd9defbe9207ee49c241b9fb201d61.jpeg');
    background-size: cover;
    background-position: center;
    display: flex;
    align-items: center;
    justify-content: center;
}
.login-card {
    border-radius: 20px;
    overflow: hidden;
    backdrop-filter: blur(12px);
    background: rgba(255,255,255,0.15);
    border: 1px solid rgba(255,255,255,0.3);
}
.login-header {
    text-align: center;
    padding: 30px 20px;
    color: #fff;
}
.login-header i {
    font-size: 48px;
    margin-bottom: 10px;
}
.login-header h4 {
    font-weight: 600;
    margin-bottom: 4px;
}
.login-header small {
    opacity: 0.85;
}
.card-body {
    background: #ffffff;
    padding: 35px 30px;
}
.form-label {
    font-size: 14px;
}
.form-control {
    border-radius: 12px;
    padding: 12px;
}
.form-control:focus {
    border-color: #6610f2;
    box-shadow: 0 0 0 0.2rem rgba(102,16,242,.25);
}
.btn-login {
    background: linear-gradient(135deg, #0d6efd, #6610f2);
    border: none;
    border-radius: 12px;
    padding: 12px;
    font-weight: 600;
    transition: 0.3s;
}
.btn-login:hover {
    transform: translateY(-1px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.2);
}
.card-footer {
    background: #f8f9fa;
    font-size: 13px;
}
.system-note {
    font-size: 12px;
    color: #6c757d;
    margin-top: 10px;
}

/* ===============================
   MOBILE FIX (REAL EFFECT)
   =============================== */
@media (max-width: 576px) {

    body {
        display: block !important;
        padding-top: 60px;
        padding-bottom: 30px;
    }

    .container {
        padding-left: 15px;
        padding-right: 15px;
    }

    .login-card {
        margin: auto;
        width: 100%;
        max-width: 360px;
    }
}

</style>
</head>

<body>

<div class="container">
<div class="row justify-content-center">
<div class="col-lg-4 col-md-6">

<div class="card login-card shadow-lg">

    <!-- HEADER -->
    <div class="login-header">
        <i class="fa-brands fa-accusoft"></i>
        <h4>Verifikasi Nilai Rapor</h4>
        <small>MAN 1 Kota Lubuklinggau</small>
    </div>

    <!-- BODY -->
    <div class="card-body">

        <form method="post" action="auth/login.php">

            <div class="mb-3">
                <label class="form-label fw-semibold">
                    <i class="fas fa-id-card me-1 text-primary"></i>
                    Username (NISN)
                </label>
                <input type="text" name="nisn" class="form-control"
                       placeholder="Masukkan NISN" required autofocus>
            </div>

            <div class="mb-4">
                <label class="form-label fw-semibold">
                    <i class="fas fa-lock me-1 text-primary"></i>
                    Password
                </label>
                <input type="password" name="password" class="form-control"
                       placeholder="Password" required>
            </div>

            <button class="btn btn-login w-100 text-white">
                <i class="fas fa-sign-in-alt me-1"></i>
                Login
            </button>

        </form>

        <div class="system-note text-center">
            <i class="fas fa-info-circle"></i>
            Gunakan password <strong>NISN + 00*</strong>
        </div>

    </div>

    <!-- FOOTER -->
    <div class="card-footer text-center text-muted">
        © <?= date('Y') ?> MAN 1 Kota Lubuklinggau • Tim Kesiswaan
    </div>

</div>

</div>
</div>
</div>

</body>
</html>
