<?php
include "../config/database.php";

if (!isset($_SESSION['siswa_id'])) {
    header("Location: ../index.php");
    exit;
}

$siswa_id = $_SESSION['siswa_id'];
$semester = $_GET['semester'] ?? 1;

// Data siswa
$s = mysqli_fetch_assoc(
    mysqli_query($conn,"SELECT * FROM siswa WHERE id='$siswa_id'")
);

// Nilai per semester + join mapel
$nilai = mysqli_query($conn,"
    SELECT m.nama AS mapel, n.nilai
    FROM nilai_raport n
    JOIN mapel m ON n.mapel = m.kode
    WHERE n.siswa_id='$siswa_id'
    AND n.semester='$semester'
    ORDER BY m.id ASC
");

// Status verifikasi
$v = mysqli_fetch_assoc(
    mysqli_query($conn,"SELECT * FROM verifikasi_nilai WHERE siswa_id='$siswa_id'")
);
$status = $v['status'] ?? 'BELUM';
?>


<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= htmlspecialchars($s['nama']) ?> | Verifikasi Nilai</title>


<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">

<style>
    body{
        background:#f4f7fb;
    }
    .mapel-card{
        background: linear-gradient(135deg,#0d6efd,#0dcaf0);
        color:#fff;
        border-radius:16px;
        padding:20px;
        height:100%;
        position:relative;
    }
    .nilai-circle{
        width:65px;
        height:65px;
        border-radius:50%;
        background:#fff;
        color:#0d6efd;
        font-size:1.3rem;
        font-weight:700;
        display:flex;
        align-items:center;
        justify-content:center;
    }

    .mapel-card{
    background: linear-gradient(135deg,#0d6efd,#0dcaf0);
    color:#fff;
    border-radius:16px;
    padding:20px;
    height:100%;
    position:relative;
    transition: all .35s ease;
    cursor:pointer;
    overflow:hidden;
}

/* efek hover utama */
.mapel-card:hover{
    transform: translateY(-6px) scale(1.04);
    box-shadow: 0 18px 40px rgba(13,110,253,.35);
}

/* highlight cahaya */
.mapel-card::after{
    content:'';
    position:absolute;
    top:-50%;
    left:-50%;
    width:200%;
    height:200%;
    background: radial-gradient(circle,rgba(255,255,255,.15),transparent 60%);
    opacity:0;
    transition:.4s;
}
.mapel-card:hover::after{
    opacity:1;
}

/* nilai bulat */
.nilai-circle{
    width:65px;
    height:65px;
    border-radius:50%;
    background:#fff;
    color:#0d6efd;
    font-size:1.3rem;
    font-weight:700;
    display:flex;
    align-items:center;
    justify-content:center;
    transition: all .35s ease;
}

/* nilai ikut naik */
.mapel-card:hover .nilai-circle{
    transform: scale(1.15);
    background:#e7f1ff;
}

/* ===================================
   MOBILE RESPONSIVE FIX - SISWA PAGE
   =================================== */
@media (max-width: 576px) {

    body {
        background: #f4f7fb;
    }

    .container {
        padding-left: 12px;
        padding-right: 12px;
    }

    /* Header siswa */
    .card-body.d-flex {
        flex-direction: column;
        align-items: flex-start !important;
        gap: 10px;
    }

    /* Badge & logout rata kiri */
    .card-body .text-end {
        width: 100%;
        text-align: left !important;
    }

    /* Filter semester */
    .row.align-items-center {
        gap: 12px;
    }

    /* Dropdown full width */
    select.form-select {
        width: 100% !important;
    }

    /* Alert info */
    .alert {
        font-size: 13px;
        padding: 10px;
    }

    /* TABEL NILAI */
    table {
        font-size: 13px;
    }

    table th,
    table td {
        padding: 8px;
    }

    /* Nilai agar menonjol */
    .nilai-besar {
        font-size: 16px;
        font-weight: 700;
        color: #0d6efd;
    }

    /* Mapel card hover dikurangi di HP */
    .mapel-card:hover {
        transform: none;
        box-shadow: none;
    }
}

</style>



</head>

<body>

<div class="container py-4">

<!-- HEADER SISWA -->
<div class="card shadow-sm mb-4">
<div class="card-body d-flex justify-content-between align-items-center">

<div>
    <h5 class="mb-1 fw-bold"><?= $s['nama'] ?></h5>
    <div class="text-muted small">
        Kelas <?= $s['kelas'] ?> | NISN <?= $s['nisn'] ?>
    </div>
</div>

<div class="text-end">
    <?php if($status=='BELUM'): ?>
        <span class="badge bg-warning text-dark px-3 py-2">
            <i class="fas fa-clock"></i> Belum Verifikasi
        </span>
    <?php else: ?>
        <span class="badge bg-success px-3 py-2">
            <i class="fas fa-check-circle"></i> Terverifikasi
        </span>
    <?php endif ?>
    <br>
    <a href="../auth/logout.php" class="btn btn-sm btn-outline-danger mt-2">
        <i class="fas fa-sign-out-alt"></i> Logout
    </a>
</div>

</div>
</div>

<!-- FILTER SEMESTER -->
<!-- FILTER SEMESTER -->
<div class="card shadow-sm mb-3">
<div class="card-body">

<div class="row align-items-center">
    
    <!-- KIRI -->
    <div class="col-md-4 d-flex align-items-center gap-3">
           Pilih Semester
        <form method="get">
            <select name="semester" class="form-select" onchange="this.form.submit()">
                <?php for($i=1;$i<=5;$i++): ?>
                    <option value="<?= $i ?>" <?= ($semester==$i?'selected':'') ?>>
                        Semester <?= $i ?>
                    </option>
                <?php endfor ?>
            </select>
        </form>
    </div>

    <!-- KANAN -->
    <div class="col-md-8">
        <div class="alert alert-primary mb-0 d-flex align-items-center">
            <i class="fa fa-bell  me-2 fs-5"></i>
            <div>
                Pilih semester lainnya untuk melihat nilai Anda.
                <br>
                Untuk verifikasi Nilai, pastikan semua nilai sudah dicek dan lakukan verifikasi di <b>Semester 5</b>.
            </div>
        </div>
    </div>

</div>

</div>
</div>

<!-- TABEL NILAI -->
<div class="card shadow-sm">
<div class="card-body p-0">

<table class="table table-hover table-bordered mb-0">
<thead class="table-primary text-center">
<tr>
    <th width="5%">No</th>
    <th>Mata Pelajaran</th>
    <th width="20%">Nilai</th>
</tr>
</thead>

<tbody>
<?php
$no=1; $total=0; $jumlah=0;
if(mysqli_num_rows($nilai)>0):
while($n=mysqli_fetch_assoc($nilai)):
$total+=$n['nilai']; $jumlah++;
?>
<tr>
    <td class="text-center"><?= $no++ ?></td>
    <td><?= $n['mapel'] ?></td>
    <td class="text-center nilai-besar"><?= $n['nilai'] ?></td>
</tr>
<?php endwhile; else: ?>
<tr>
    <td colspan="3" class="text-center text-muted py-4">
        <i class="fas fa-info-circle"></i> Nilai belum tersedia
    </td>
</tr>
<?php endif ?>
</tbody>

<?php if($jumlah>0): ?>
<tfoot class="table-light">
<tr>
    <th colspan="2">Total Nilai</th>
    <th class="text-center"><?= $total ?></th>
</tr>
<tr>
    <th colspan="2">Rata-rata</th>
    <th class="text-center fw-bold">
        <?= number_format($total/$jumlah,2) ?>
    </th>
</tr>
</tfoot>
<?php endif ?>
</table>

</div>
</div>

<!-- VERIFIKASI -->
<?php if($semester == 5 && $status=='BELUM'): ?>
<div class="alert alert-warning mt-4">
    <i class="fas fa-info-circle"></i>
    Pastikan seluruh nilai dari Semester 1 sampai 5 sudah benar sebelum verifikasi.
</div>

<div class="text-end">
<form method="post" action="verifikasi.php">
    <button class="btn btn-success px-4">
        <i class="fas fa-check"></i> Verifikasi Nilai
    </button>
</form>
</div>

<?php elseif($status=='SUDAH'): ?>
<div class="alert alert-success mt-4 d-flex justify-content-between align-items-center">
    <div>
        <i class="fas fa-check-circle"></i>
        Nilai telah diverifikasi pada
        <strong><?= $v['waktu_verifikasi'] ?></strong>
    </div>

    <a href="cetak_nilai_semua.php?id=<?= $siswa_id ?>"
       target="_blank"
       class="btn btn-outline-success btn-sm">
        <i class="fas fa-file-pdf"></i> Download Nilai PDF
    </a>
</div>
<?php endif ?>



</div>

<!-- MODAL PERINGATAN -->
<div class="modal fade" id="peringatanModal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">
          <i class="fas fa-exclamation-circle"></i> Perhatian
        </h5>
      </div>
      <div class="modal-body text-center">
        <p class="mb-2">
          Silakan <strong>periksa nilai Anda dengan teliti</strong><br>
          dari <strong>Semester 1 sampai Semester 5</strong>.
        </p>
        <p class="text-muted small">
          Jika terdapat kesalahan nilai, segera laporkan.
        </p>
      </div>
      <div class="modal-footer justify-content-center">
        <button type="button" class="btn btn-primary px-4" data-bs-dismiss="modal">
          <i class="fas fa-check"></i> Saya Mengerti
        </button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener("DOMContentLoaded", function () {
<?php if (!empty($_SESSION['popup_nilai'])): ?>
    var modal = new bootstrap.Modal(
        document.getElementById('peringatanModal'),
        {
            backdrop: 'static',
            keyboard: false
        }
    );
    modal.show();
<?php unset($_SESSION['popup_nilai']); endif; ?>
});
</script>

</body>
</html>

